// MenuPlus.js Ver.1.0.0
// MIT License (C) 2022 あわやまたな
// http://opensource.org/licenses/mit-license.php

/*:
* @target MZ
* @plugindesc メニューを若干豪華にします。
* @orderAfter FesCursor
* @orderAfter SelectableWindow
* @author あわやまたな (Awaya_Matana)
* @url https://awaya3ji.seesaa.net/
* @help 
*
* [更新履歴]
* 2022/08/28：Ver.1.0.0　公開。
*
* @param slideIn
* @text スライドイン
* @desc メニュー開始時にスライドインします。
* @default true
* @type boolean
*
* @param fesFormation
* @text フェス形式の並べ替え
* @desc パーティメンバーの並べ替えをフェス風にします。
* @default true
* @type boolean
*
* @param disableBlur
* @text ぼかし無効化
* @desc メニュー背景のぼかしを消します。
* @default true
* @type boolean
*
* @param iconTable
* @text アイコン対応表
* @desc コマンドの左に表示するアイコンのIDを入力します。
* @type struct<iconTable>
* @default {"enabled":"true","item":"208","skill":"76","equip":"137","status":"77","formation":"75","options":"242","save":"297","gameEnd":"229"}
*
* @param goldIcon
* @text 所持金アイコン
* @desc 所持金ウィンドウの左に表示するアイコンのIDを入力します。
* @default 0
*
*/

/*~struct~iconTable:
*
* @param enabled
* @text メニューアイコン有効化
* @desc メニューコマンドのアイコン表示を許可する。
* @type boolean
* @default true
*
* @param item
* @text アイテム
* @default 208
*
* @param skill
* @text スキル
* @default 76
*
* @param equip
* @text 装備
* @default 137
*
* @param status
* @text ステータス
* @default 77
*
* @param formation
* @text 並べ替え
* @default 75
*
* @param options
* @text オプション
* @default 242
*
* @param save
* @text セーブ
* @default 297
*
* @param gameEnd
* @text ゲーム終了
* @default 229
*
*/

'use strict';

{
	//プラグイン名取得。
	const script = document.currentScript;
	const pluginName = document.currentScript.src.match(/^.*\/(.*).js$/)[1];

	const parameters = PluginManager.parameters(pluginName);
	const menuBgmVolume = Number(parameters["menuBgmVolume"]);
	const menuBgsVolume = Number(parameters["menuBgsVolume"]);
	const slideIn = parameters["slideIn"] === "true";
	const fesFormation = parameters["fesFormation"] === "true";
	const disableBlur = parameters["disableBlur"] === "true";
	const iconTable = JSON.parse(parameters["iconTable"]);
	const enableMenuIcon = iconTable["enabled"] === "true";
	delete iconTable["enabled"];
	for (const key in iconTable) {
		iconTable[key] = parseInt(iconTable[key]);
	};
	const goldIcon = parseInt(parameters["goldIcon"] || 0);

	//-----------------------------------------------------------------------------
	// Window_MenuCommand

	if (enableMenuIcon) {
		const _Window_MenuCommand_drawItem = Window_MenuCommand.prototype.drawItem;
		Window_MenuCommand.prototype.drawItem = function(index) {
			this._symbolIconIndex = iconTable[this.commandSymbol(index)] || 0;
			_Window_MenuCommand_drawItem.call(this, index);
		};

		const _Window_MenuCommand_drawText = Window_MenuCommand.prototype.drawText;
		Window_MenuCommand.prototype.drawText = function(text, x, y, maxWidth, align) {
			const iconIndex = this._symbolIconIndex || 0;
			this._symbolIconIndex = 0;
			if (iconIndex === 0) {
				_Window_MenuCommand_drawText.apply(this, arguments);
			} else {
				const item = { "name": text, "iconIndex": iconIndex };
				this.drawItemName(item, x, y, maxWidth);
			}
		};
	}

	if (fesFormation) {

		//-----------------------------------------------------------------------------
		// Window_MenuCommand

		Window_MenuStatus.prototype.drawPendingItemBackground = function(index) {};

		const _Window_MenuStatus_select = Window_MenuStatus.prototype.select;
		Window_MenuStatus.prototype.select = function(index) {
			const lastIndex = this.index();
			_Window_MenuStatus_select.call(this, index);
			const pendingIndex = this.pendingIndex();
			if (pendingIndex >= 0) {
				this.setPendingIndex(index);
				$gameParty.swapOrder(lastIndex, index);
				this.redrawItem(index);
				this.redrawItem(lastIndex);
			}
		};

		// SelectableWindow
		const _Window_MenuStatus_selectableWindowCursorRectEnabled = Window_MenuStatus.prototype.selectableWindowCursorRectEnabled;
		Window_MenuStatus.prototype.selectableWindowCursorRectEnabled = function(index) {
			return (!this.arrowCursorVisible || !this._backCursorCanInvisible()) && _Window_MenuStatus_selectableWindowCursorRectEnabled.call(this, index);
		};

		// FesCursor
		const _Window_MenuStatus__backCursorCanInvisible = Window_MenuStatus.prototype._backCursorCanInvisible;
		Window_MenuStatus.prototype._backCursorCanInvisible = function() {
			const canInvisible = this._formationMode && this.pendingIndex() < 0;
			return canInvisible || _Window_MenuStatus__backCursorCanInvisible.call(this);
		};

		const _Window_MenuStatus__makeCursorAlpha = Window_MenuStatus.prototype._makeCursorAlpha;
		Window_MenuStatus.prototype._makeCursorAlpha = function() {
			const pendingEnabled = this._formationMode && this.pendingIndex() >= 0;
			return pendingEnabled ? this.contentsOpacity / 255 : _Window_MenuStatus__makeCursorAlpha.call(this);
		};

		//-----------------------------------------------------------------------------
		// Scene_Menu

		Scene_Menu.prototype.onFormationOk = function() {
			const index = this._statusWindow.index();
			const pendingIndex = this._statusWindow.pendingIndex();
			if (pendingIndex >= 0) {
				this._statusWindow.setPendingIndex(-1);
			} else {
				this._statusWindow.setPendingIndex(index);
			}
			this._statusWindow.activate();
		};

		Scene_Menu.prototype.onFormationCancel = function() {
			if (this._statusWindow.pendingIndex() >= 0) {
				this._statusWindow.setPendingIndex(-1);
				this._statusWindow.activate();
			} else {
				this._statusWindow.deselect();
				this._commandWindow.activate();
			}
		};

	}

	if (disableBlur) {
		let menuBitmap = null;
		const exclutionList1 = new Set(["Scene_Save", "Scene_Load", "Scene_Remove", "Scene_GameEnd", "Scene_Options"]);
		const exclutionList2 = new Set(["Scene_GameEnd"]);

		const _Scene_MenuBase_createBackground = Scene_MenuBase.prototype.createBackground;
		Scene_MenuBase.prototype.createBackground = function() {
			_Scene_MenuBase_createBackground.call(this);
			if (!exclutionList1.has(this.constructor.name)) {
				const filter = this._backgroundSprite.filters.shift();
				filter.destroy();
				if (!exclutionList2.has(this.constructor.name)) {
					this.setBackgroundOpacity(255);
				}
			}
		};

		const _Scene_Menu_terminate = Scene_Menu.prototype.terminate;
		Scene_Menu.prototype.terminate = function() {
			_Scene_Menu_terminate.call(this);
			menuBitmap = SceneManager.snap();
		};

		const _Scene_GameEnd_createBackground = Scene_GameEnd.prototype.createBackground;
		Scene_GameEnd.prototype.createBackground = function() {
			_Scene_GameEnd_createBackground.call(this);
			const defaultImage = this._backgroundSprite;
			const w = defaultImage.width;
			const h = defaultImage.height;
			this._backgroundSprite.bitmap = new Bitmap(w, h);
			defaultImage.bitmap.blt(this._backgroundSprite, 0, 0, w, h, 0, 0);
			this._backgroundSprite.bitmap.blt(menuBitmap, 0, 0, w, h, 0, 0);
			menuBitmap.destroy();
		};

		const _Scene_GameEnd_terminate = Scene_GameEnd.prototype.terminate;
		Scene_GameEnd.prototype.terminate = function() {
			_Scene_GameEnd_terminate.call(this);
			this._backgroundSprite.bitmap.destroy();
		};
	}

	if (goldIcon) {
		//-----------------------------------------------------------------------------
		// Window_Gold

		const _Window_Gold_drawCurrencyValue = Window_Gold.prototype.drawCurrencyValue;
		Window_Gold.prototype.drawCurrencyValue = function(value, unit, x, y, width) {
			const iconY = y + (this.lineHeight() - ImageManager.iconHeight) / 2;
			const textMargin = ImageManager.iconWidth + 4;
			const itemWidth = Math.max(0, width - textMargin);
			this.drawIcon(goldIcon, x, iconY);
			_Window_Gold_drawCurrencyValue.call(this, value, unit, x + textMargin, y, itemWidth);
		};
	}

	if (slideIn) {
		//-----------------------------------------------------------------------------
		// Scene_Menu

		const slideDuration = 5;
		const _Scene_Menu_initialize = Scene_Menu.prototype.initialize;
		Scene_Menu.prototype.initialize = function() {
			this._windowData = [];
			this._slideDuration = this._wholeSlideDuration = 0;
			this._slideoutRequest = false;
			_Scene_Menu_initialize.call(this);
		};

		Scene_Menu.prototype.popScene = function() {
			const duration = slideDuration - this._slideDuration;
			this._slideDuration = this._wholeSlideDuration = duration;
			this._slideoutRequest = true;
			this._windowData.forEach(data => {
				const window = data.window;
				const offsetX = Math.floor((Graphics.width - Graphics.boxWidth)/2);
				data.targetX = data.dir === 4 ? -window.width - offsetX : Graphics.boxWidth + offsetX;
			});
		};

		const _Scene_Menu_create = Scene_Menu.prototype.create;
		Scene_Menu.prototype.create = function() {
			_Scene_Menu_create.call(this);
			this.addWindowData();
		};

		Scene_Menu.prototype.addWindowData = function() {
			this._windowLayer.children.forEach(window => {
				if (window.constructor.name === "Sprite_Button") return;
				const dir = Graphics.boxWidth/2 > window.x + window.width/2 ? 4 : 6;
				const data = {
					"window": window,
					"targetX": window.x,
					"dir": dir,
					"originX": window.x
				};
				this._windowData.push(data);
			});
			if (SceneManager.isPreviousScene(Scene_Map)) {
				this._slideDuration = this._wholeSlideDuration = slideDuration;
				this._windowData.forEach(data => {
					const window = data.window;
					const offsetX = Math.floor((Graphics.width - Graphics.boxWidth)/2);
					window.x = data.dir === 4 ? -window.width - offsetX : Graphics.boxWidth + offsetX;
				});
			}
		};

		const _Scene_Menu_update = Scene_Menu.prototype.update;
		Scene_Menu.prototype.update = function() {
			_Scene_Menu_update.call(this);
			if (this._slideDuration > 0) {
				const d = this._slideDuration;
				const wd = this._wholeSlideDuration;
				const lt = (wd - d) / wd;
				const t = (wd - d + 1) / wd;
				this._windowData.forEach(data => {
					const window = data.window;
					const current = window.x;
					const target = data.targetX;
					const start = (current - target * lt) / (1 - lt);
					window.x = start + (target - start) * t;
				});
				this._slideDuration--;
				if (this._slideDuration <= 0 && this._slideoutRequest) {
					SceneManager.pop();
				}
			}
		};

		const _Scene_Menu_terminate = Scene_Menu.prototype.terminate;
		Scene_Menu.prototype.terminate = function() {
			this._windowData.forEach(data => {
				const window = data.window;
				window.x = data.originX;
			});
			_Scene_Menu_terminate.call(this);
		};

	}

}